<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/


/* FIND LOG Home Directory */

$page_title = "SS Run Test Case";
$page_h1 = "Run Test Case and Record Test Results";
$root = '/tmp/';
include "ft_ss_need_logs.php";
$dribble_file = fopen ("/tmp/dribble-res.txt","w");
fprintf ($dribble_file,"Start\n");
fprintf ($dribble_file,"Parms -- Engine: %s Data Set %s\n",$engine[0],$ds[0]);
/*
if (file_exists('/Volumes/FT-LOGS')){
 	$root = '/Volumes/FT-LOGS/';
} elseif (file_exists('/media/FT-LOGS')){
 	$root = '/media/FT-LOGS/';
}
if (file_exists($root . 'ss_se.txt')){
	$engine = file($root . 'ss_se.txt');
	$engine = $engine[0];
	$need_ds = 0;
}
else {
	include "ft_ss_get_engine.php";
	exit("");
}
$need_ds = 1;
if (file_exists($root . 'ss_ds.txt')){
	$ds = file($root . 'ss_ds.txt');
	$need_ds = 0;
}
else {
	include "ft_ss_data_set.php";
	exit("");
}

*/
$case_id = $_POST['case_to_run'];

/* $root is LOG home */

fprintf ($dribble_file,"root: %s\n",$root);

printf ("<p>Testing Search Engine $engine for case $case_id");
if (strcmp($ds[0],'UNIX') == 0){
	$f = file('unix-ex.txt');
	echo ' using UNIX Data Set';
}
else {
	$f = file('win-ex.txt');
	echo ' using Windows Data Set';
}

$case_log_index ['goof'] = 'crud';
$saved_comments = "";
/*
printf ("</p>");
printf ("<p> Case Log File: ");
$case_log_path = $root . '/' . $engine . '/' . $ds[0] . '/' . $case_id . '.txt';
if (strcmp($ds[0],'UNIX') == 0){
*/
fprintf ($dribble_file,"Engine: %s Data Set %s\n",$engine,$ds[0]);
fprintf ($dribble_file,"Engine: %s Data Set %s\n",$engine,$ds);
$case_log_path = $root . '/' . $engine[0] . '/' . $ds[0] . '/' . $case_id . '.txt';
fprintf ($dribble_file,"Log Path: %s\n",$case_log_path);
/*
printf ($case_log_path);
*/
if (file_exists($case_log_path)){
	$case_log_file = fopen ($case_log_path,"r");
	$no_log = 0;
	$in_comment = False;
	while (!feof($case_log_file)){
		$line = fgets($case_log_file);
		fprintf ($dribble_file,"LOG: %s",$line);
		/*
		printf ('<br>');
		printf ($line);
		*/
		$lx_split = explode(':',$line);
		if ($in_comment){
			$saved_comments = $saved_comments . $line;
		}
		else {
			if (strcmp($lx_split[0],"comments") == 0){
				$in_comment = True;
			}
			if (strcmp($lx_split[0],"active_hit") == 0 ||
				strcmp($lx_split[0],"unalloc_hit") == 0 ||
				strcmp($lx_split[0],"deleted_hit") == 0 
			){
				/*
				printf ("*** HIT *** %s",substr($lx_split[1],0,4));
				*/
				$case_log_index[substr($lx_split[1],0,4)] = "checked";
			}
			if (strcmp($lx_split[0],"meta_hit") == 0){
				$mix = $lx_split[1].':'.$lx_split[2];
				$case_log_index[$mix] = "checked";
			}
		}
	}
	/*
	print_r($case_log_index);
	*/
} else {
	fprintf ($dribble_file,"No log file\n");
	$no_log = 1;
}
printf ("</p>");


$look_for_end = 0;
$is_active = 0;
$is_deleted = 0;
$is_unallocated = 0;
$is_meta = 0;
$is_string = 0;
$is_setting = 0;
printf ('<form method="POST"');
printf ('action="/stringsearch/ft_ss_save_results.php">');
$who = '';
if (file_exists($root . 'ss_ur.txt')){
	$who = file($root . 'ss_ur.txt');
}
$get_who = <<<END
<p>Tester Name:  
<input name="who" style="background-color:#AAFFAA"
type="text" autofocus required value="%s"><br>
<p>Test Host Name:  
<input name="host" style="background-color:#AAFFAA"
type="text" autofocus required value="%s"><br>
<p>
END;

$whom = $who[0];
$host = $who[1];
printf ($get_who,$whom,$host);
foreach ($f as $s){
	$z = explode (' ',trim($s));
	fprintf ($dribble_file,"Line in file ==> %s\n",$s);
	if (strpos($s,'Case:') === false){
		if ($look_for_end == 1){
		if (strlen($s) <= 1){
			continue;
		}
		if (strcmp ($z[0],'Strings') == 0){
			$is_active = 0;
			$is_deleted = 0;
			$is_unallocated = 0;
			$is_meta = 0;
			$is_setting = 0;
			$is_string = 1;
		} elseif (strcmp ($z[0],'Active') == 0){
				fprintf ($dribble_file,"Start Active -- %s\n",$s);
			$is_deleted = 0;
			$is_unallocated = 0;
			$is_meta = 0;
			$is_string = 0;
			$is_setting = 0;
			$is_active = 1;
		} elseif (strcmp ($z[0],'Deleted') == 0){
			$is_active = 0;
			$is_unallocated = 0;
			$is_meta = 0;
			$is_string = 0;
			$is_setting = 0;
			$is_deleted = 1;
		} elseif (strcmp ($z[0],'Unallocated') == 0){
				fprintf ($dribble_file,"Start Unallocated -- %s\n",$s);
			$is_active = 0;
			$is_deleted = 0;
			$is_meta = 0;
			$is_string = 0;
			$is_setting = 0;
			$is_unallocated = 1;
		} elseif (strcmp ($z[0],'Meta-Data') == 0){
			$is_active = 0;
			$is_deleted = 0;
			$is_unallocated = 0;
			$is_string = 0;
			$is_setting = 0;
			$is_meta = 1;
		} elseif (strcmp ($z[0],'Settings') == 0){
			$is_active = 0;
			$is_deleted = 0;
			$is_unallocated = 0;
			$is_meta = 0;
			$is_string = 0;
			$is_setting = 1;
		} else{
			if ($is_active == 1){
				$a_list [] = $s;
				fprintf ($dribble_file,"Active -- %s\n",$s);
			}
			if ($is_setting == 1){
				$set_list [] = $s;
			}
			if ($is_string == 1){
				$str_list [] = $s;
			}
			if ($is_deleted == 1){
				$d_list [] = $s;
			}
			if ($is_unallocated == 1){
				$u_list [] = $s;
				fprintf ($dribble_file,"Unallocated -- %s\n",$s);
			}
			if ($is_meta == 1){
				$m_list [] = $s;
				fprintf ($dribble_file,"META -- %s\n",$s);
			}
		}

	}
	}
	else {
		if ($look_for_end == 1){
			$look_for_end = 0;
			$look_for_end = 0;
			$is_active = 0;
			$is_deleted = 0;
			$is_unallocated = 0;
			$is_meta = 0;
			$is_string = 0;
			$is_setting = 0;
			if (isset($set_list)){
				echo "Search Tool Settings:\n";
				printf ("<table>\n");
				printf ("<tr><td>");
				printf ("Adjust search tool parameters to the following:");
				printf ("<tr><td>");
				$br = '';
				foreach ($set_list as $ww){
					printf ("$br");
					$br = '<br>';
					echo $ww;
				}
				printf ("</td></tr>");
				printf ("</table>\n");
			}
			if (isset($str_list)){
				echo "Search Strings:\n";
				printf ("<table>\n");
				printf ("<tr><td>");
				printf ("Ask the search tool to look for each of the following strings:");
				printf ("<tr><td>");
				$br = '';
				foreach ($str_list as $ww){
					printf ("$br");
					$br = '<br>';
					echo $ww;
				}
				printf ("</td></tr>");
				printf ("</table>\n");
			}
?>
<p>Run the tool and record the results below.
<p>For a string located in an Active File or a Deleted File, the search tool should report the
containing file name and the text string found along with some context around
the reported string. Immediatly after the target string the string ID will be
included in the surrounding context. This should be enough information to select
the correct entry in the form below.
<?php
			if ((count($a_list) == count($d_list)) and (count($a_list) > 0)) {
				$n = count($a_list);
				printf ("<table>\n");
					printf ("<tr>");
					printf ("<th colspan=2>Active Files</th>");
					printf ("<th colspan=2>Deleted Files</th>");
					printf ("</tr>\n");
				for ($i = 0; $i < $n; $i++){
					printf ("<tr>");
					printf ("<td>");
					$str_id = substr($a_list[$i],0,4);
					$is_checked = "";
					if (array_key_exists ($str_id,$case_log_index)){
						$is_checked = 'checked="checked"';
					}
					else {
						if ($no_log == 1){
							$is_checked = 'checked="checked"';
						}
					}
					printf ('<input type="checkbox" 
						%s name="ActiveFiles[]" value="%s">',
						$is_checked,$a_list[$i]);
					printf ("</td>\n");
					printf ("<td>");
					echo $a_list[$i];
					printf ("</td>");
					printf ("<td>");
					$str_id = substr($d_list[$i],0,4);
					$is_checked = "";
					if (array_key_exists ($str_id,$case_log_index)){
						$is_checked = 'checked="checked"';
					}
					else {
						if ($no_log == 1){
							$is_checked = 'checked="checked"';
						}
					}
					printf ('<input type="checkbox" 
						%s name="DeletedFiles[]" value="%s">',
						$is_checked,$d_list[$i]);
					printf ("</td>\n");
					printf ("<td>");
					echo $d_list[$i];
					printf ("</td>");
					printf ("</tr>\n");
				}
				printf ("</table>\n");
			} else {
				$n = count($a_list);
				/*
				for ($i = 0; $i < $n; $i++){
					echo $i .' ==> '.$a_list[$i];
					echo "\n";
				}
				*/
				$n = count($d_list);
				/*
				for ($i = 0; $i < $n; $i++){
					echo $i .' ==> '.$d_list[$i];
					echo "\n";
				}
				*/
				$n = count($a_list);
				if ($n > 0){
				printf ("<table>\n");
					printf ("<tr>");
					printf ("<th colspan=2>Active Files</th>");
					printf ("</tr>\n");
				for ($i = 0; $i < $n; $i++){
					printf ("<tr>");
					printf ("<td>");
					$str_id = substr($a_list[$i],0,4);
					$is_checked = "";
					if (array_key_exists ($str_id,$case_log_index)){
						$is_checked = 'checked="checked"';
					}
					else {
						if ($no_log == 1){
							$is_checked = 'checked="checked"';
						}
					}
					printf ('<input type="checkbox" 
						%s name="ActiveFiles[]" value="%s">',
						$is_checked,$a_list[$i]);
						/*
					printf ('<input type="checkbox" name="ActiveFiles[]" value="%s">',
						$a_list[$i]);
						*/
					printf ("</td>\n");
					printf ("<td>");
					echo $a_list[$i];
					printf ("</td>");
					printf ("</tr>\n");
				}
				printf ("</table>\n");
				}
				$n = count($d_list);
				if ($n > 0){
				printf ("<table>\n");
					printf ("<tr>");
					printf ("<th colspan=2>Deleted Files</th>");
					printf ("</tr>\n");
				for ($i = 0; $i < $n; $i++){
					printf ("<tr>");
					printf ("<td>");
					$str_id = substr($d_list[$i],0,4);
					$is_checked = "";
					if (array_key_exists ($str_id,$case_log_index)){
						$is_checked = 'checked="checked"';
					}
					else {
						if ($no_log == 1){
							$is_checked = 'checked="checked"';
						}
					}
					printf ('<input type="checkbox" 
						%s name="DeletedFiles[]" value="%s">',
						$is_checked,$d_list[$i]);
					/*
					printf ('<input type="checkbox" name="DeletedFiles[]" value="%s">',
						$d_list[$i]);
						*/
					printf ("</td>\n");
					printf ("<td>");
					echo $d_list[$i];
					printf ("</td>");
					printf ("</tr>\n");
				}
				printf ("</table>\n");
				}
			}
			$n = count($u_list);
fprintf ($dribble_file,"Unallocated List size: %d\n",$n);
			if ($n > 0){
?>

<p>For a string located in Unallocated Space the search tool should provide some location
information and some context surronding the reported string. The Unallocated Space 
form lists for each string instance, the string ID, byte offset within the dd image, sector 
offset within the dd image, the target string and the string encoding (ASCII or UTF).
<?php
			printf ("<br><table>\n");
			printf ("<tr>");
			printf ("<th colspan=2>Unallocated Space</th>");
			printf ("</tr>\n");
			for ($i = 0; $i < $n; $i++){
				printf ("<tr>");
				printf ("<td>");
					$str_id = substr($u_list[$i],0,4);
					$is_checked = "";
					if (array_key_exists ($str_id,$case_log_index)){
						$is_checked = 'checked="checked"';
					}
					else {
						if ($no_log == 1){
							$is_checked = 'checked="checked"';
						}
					}
					printf ('<input type="checkbox" 
						%s name="UnallocFiles[]" value="%s">',
						$is_checked,$u_list[$i]);
				/*
				printf ('<input type="checkbox" name="UnallocFiles[]" value="%s">',
					$u_list[$i]);
					*/
				printf ("</td>\n");
				printf ("<td>");
				echo $u_list[$i];
				printf ("</td>");
				printf ("</tr>\n");
			}
			printf ("</table>\n");
			}
		}
		if (strcmp($z[1],$case_id) == 0){
			$look_for_end = 1;
		}
	}
}
echo "\n";
/********************************************************/
/********************************************************/
$d_row = <<<END
          <td style="vertical-align: top;">%s<br>
          </td>
          <td style="vertical-align: top;">%s<br>
          </td>
          <td style="vertical-align: top;">
			<input %s type="checkbox" name="Meta[]" value="%s">
			<input type="hidden" name="Ref[]" value="%s">
		  <br>
          </td>
        </tr>
END;
/********************************************************/
/********************************************************/
$t_head = <<<END
    <table style=" text-align: left; width: 40%;" border="1"
      cellpadding="2" cellspacing="2">
      <tbody>
        <tr>
          <td style="vertical-align: top;">String<br>
          </td>
          <td style="vertical-align: top;">&nbsp;Partition<br>
          </td>
          <td style="vertical-align: top;">Count<br>
          </td>
          <td style="vertical-align: top;">Seen<br>
          </td>
        </tr>
END;
$t_tail = <<<END
      </tbody>
    </table>
	<br>
END;
/********************************************************/
/********************************************************/
$f_row = <<<END
        <tr>
          <td colspan="1" rowspan="%d" style=" vertical-align: middle;">%s<br>
          </td>
END;
/********************************************************/
/********************************************************/

/* Meta-data */
$meta1 = <<<END
<p>Record Meta-data hits in the table below.
For a string located in file system meta-data, you only need to record if meta-data was
reported for a given string in a particular partition (file system).
<p>Select the checkbox in the <b>Seen</b> column for the given string and partition if the
tested tool gave an adaquate response for finding the target string
from the partition meta-data. The "count" column indicates the number of
instances of the given string in the partition, but a tool may, for example,
just return the first hit for a string in the NTFS $MFT.
<br>
END;
$the_string = 'unassigned';

$n = count($m_list);
if ($n > 0){
printf ('%s',$meta1);
printf ('%s',$t_head);
fprintf ($dribble_file,"META-DATA Present\n");
$sx = 0;
$is_data = 0;
/* $n is the number of meta data items in the list */
fprintf ($dribble_file,"************************************\n");
$string_index = 'NotSet';
for ($i = 0; $i < $n; $i++){
	fprintf ($dribble_file,$m_list[$i]);
	$meta_list = explode(':',$m_list[$i]);
	if (strcmp($meta_list[0],'String') == 0){
		$string_index = trim($meta_list[1]);
		$string_cnt[$string_index] = 0;
		fprintf ($dribble_file,"Set to zero %s\n",$string_index);
	}
	else {
		$string_cnt[$string_index] = $string_cnt[$string_index] + 1;
		fprintf ($dribble_file,"Add one to %s\n",$string_index);
	}
}
fprintf ($dribble_file,"************************************\n");
foreach ($string_cnt as $key_cnt => $cnt_value){
	
	fprintf ($dribble_file,"Counts %s for %d\n",$key_cnt,$cnt_value);
}
fprintf ($dribble_file,"************************************\n");


$the_string = "NoString";
for ($i = 0; $i < $n; $i++){
	$meta_list = explode(':',$m_list[$i]);
	if (strcmp($meta_list[0],'String') == 0){
		$the_string = trim($meta_list[1]);
		printf ($f_row,$string_cnt[$the_string],$the_string);
		$first_row = 1;
	}
	else {
		if ($first_row == 1){
			$first_fow = 0;
		}
		else {
			printf ("<tr>");
		}
		$partition_name = $meta_list[1];
		$partition_cnt = $meta_list[3];
		$mix =  trim($the_string). ':' . $partition_name;
		$check_value = $mix . ':' . $partition_cnt;
		$is_checked = "";
		if (array_key_exists ($mix,$case_log_index)){
			$is_checked = 'checked="checked"';
		}
		fprintf ($dribble_file,"DATA ROW: partition %s CNT %s Checked %s\n",
			$partition_name,$partition_cnt,$is_checked);
			$row_xxx = sprintf ($d_row,$partition_name,$partition_cnt,$is_checked,
				$check_value,$check_value);
			printf ($d_row,$partition_name,$partition_cnt,$is_checked,
				$check_value,$check_value);
		fprintf ($dribble_file,$row_xxx);
	}
}


printf ('%s',$t_tail);
/********************************************************/
if (1 == 2){
printf ('%s',$t_head);
for ($i = 0; $i < $n; $i++){
	fprintf ($dribble_file,"ITEM: %s\n",$m_list[$i]);
	$meta_list = explode(':',$m_list[$i]);
	if (strcmp($meta_list[0],'String') == 0){
		fprintf ($dribble_file,"Found String %s",$meta_list[1]);
		if ($is_data == 1){
			$check_value = trim($the_string). ':' . $part_name[0] . ':' . $part_cnt[0];
			$mix =  trim($the_string). ':' . $part_name[0] ;
			$is_checked = "";
			if (array_key_exists ($mix,$case_log_index)){
				$is_checked = 'checked="checked"';
			}

			printf ($f_row,1,$the_string);
			printf ($d_row,$part_name[0],$part_cnt[0],$is_checked,$check_value,$check_value);
			for ($wx = 1; $wx < $sx; $wx += 1){
				printf ('<tr>');
				$check_value = trim($the_string). ':' . $part_name[$wx] . ':' . $part_cnt[$wx];
				$mix =  trim($the_string). ':' . $part_name[$wx] ;
				$is_checked = "";
				if (array_key_exists ($mix,$case_log_index)){
					$is_checked = 'checked="checked"';
				}
fprintf ($dribble_file,"DATA ROW1 %s = %s = %s\n",$part_name[$wx],$part_cnt[$wx],$is_checked);
				printf ($d_row,$part_name[$wx],$part_cnt[$wx],$is_checked,$check_value,$check_value);
}
		}
		$is_data = 1;
		$the_string = $meta_list[1];
		$sx = 0;
	}
	else {
		if (strcmp($meta_list[0],'Partition') == 0){
			$part_name[$sx] = $meta_list[1];
			$part_cnt[$sx] = $meta_list[3];
			$sx += 1;
			fprintf ($dribble_file,"PART Found: %s %s",$meta_list[1],$meta_list[3]);
		}
	}
}

fprintf ($dribble_file,"======================");

printf ($f_row,$sx,$the_string);
fprintf ($dribble_file,"First Row: %d %s",$sx,$the_string);
$check_value = trim($the_string). ':' . $part_name[0] . ':' . $part_cnt[0];
$mix =  trim($the_string). ':' . $part_name[0] ;
$is_checked = "";
if (array_key_exists ($mix,$case_log_index)){
	$is_checked = 'checked="checked"';
}
printf ($d_row,$part_name[0],$part_cnt[0],$is_checked,$check_value,$check_value);
fprintf ($dribble_file,"DATA ROW %s = %s = %s\n",$part_name[0],$part_cnt[0],$is_checked);
for ($wx = 1; $wx < $sx; $wx += 1){
	printf ('<tr>');
	$check_value = trim($the_string). ':' . $part_name[$wx] . ':' . $part_cnt[$wx];
	$mix =  trim($the_string). ':' . $part_name[$wx] ;
	$is_checked = "";
	if (array_key_exists ($mix,$case_log_index)){
		$is_checked = 'checked="checked"';
	}
	printf ($d_row,$part_name[$wx],$part_cnt[$wx],$is_checked,$check_value,$check_value);
}
printf ('%s',$t_tail);
}

}


/********************************************************/
/********************************************************/

$hide_stuff = <<<END
<h2>Comments and Observations</h2>
<p>
<label for="textarea">Comments & Observations to include in test report:</label><br>
<textarea name="comments" cols="60" rows="10" id="textarea">%s</textarea>
</p>
<br>
<input type="hidden" name="n_active" value="%d">
<input type="hidden" name="n_deleted" value="%d">
<input type="hidden" name="n_unalloc" value="%d">
<input type="hidden" name="case_to_run" value="%s">
<input value="Save Results" type="submit"> </p>
</form>
END;

printf ($hide_stuff,$saved_comments,count($a_list),count($d_list),count($u_list),$case_id);

include "ft_ss_tail.php";
?>
